/*
---------------------- Apache Version 2.0 License ----------------------
Copyright 2023 René Steger

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
------------------------------------------------------------------------
*/

-- create an instance of the Rexx class
rexxHandler=.RexxAppHandler~new
-- the abstract "start" method will be served by rexxHandler
rxApp=BSFCreateRexxProxy(rexxHandler, ,"javafx.application.Application")
-- launch the application and invokes "start"
rxApp~launch(rxApp~getClass, .nil)

-- get Java Support
::REQUIRES "BSF.CLS"

-- the Rexx handler for javafx.application.Application
::CLASS RexxAppHandler

-- will be called by JavaFX
::METHOD start
-- accesses the primary stage
USE ARG primaryStage

-- change directory to program location
parse source . . s
call directory filespec('loc', s)

-- setting title to the Stage
primaryStage~setTitle("Box_PointLight")

-- get access to the JavaFX colors
col=bsf.loadClass("javafx.scene.paint.Color")

-- create the root node
root=.bsf~new("javafx.scene.Group")

-- create a box
box=.bsf~new("javafx.scene.shape.Box")
-- set the width, height and depth of the box
box~width=200
box~height=200
box~depth=200
-- set position of the box
box~translateX=300
box~translateY=200
-- set rotation of the box
point=.bsf~new("javafx.geometry.Point3D", 1, 1, 1)
box~rotate=45
box~rotationAxis=point

-- load an image
img=.bsf~new("javafx.scene.image.Image", "file:wood.jpg")

-- preparing the material
material=.bsf~new("javafx.scene.paint.PhongMaterial")
material~diffuseMap=img

-- set the material to box
box~setMaterial(material)

-- create a point light
light=.bsf~new("javafx.scene.PointLight")
light~color=col~WHITE
-- set position of the light
light~translateX=500
light~translateY=100
light~translateZ=-100

-- add objects to the root node
root~getChildren~~add(box)~~add(light)

-- create a perspective camera
camera=.bsf~new("javafx.scene.PerspectiveCamera")
-- set position of the camera
camera~translateX=0
camera~translateY=0
camera~translateZ=0

-- create a scene
scene=.bsf~new("javafx.scene.Scene", root, 600, 400)
-- add camera to the scene
scene~setCamera(camera)

-- put the scene on the stage
primaryStage~setScene(scene)
-- display the content of the stage
primaryStage~show